//Workin In Progress

//One More Try's ported storybook shader from guest.r.  Sorry this is done in the tutorial file, it's just a quick 10 minute test of reshade.
// ColoredStorybook shader
// by guest(r)
// License: GNU-GPL

/*
The next part is for a program to set the values.

Value name (no spaces)
Range of slider, default value.

Example_Name
Range0-100, 50

Do not manually create the #define lines if using the program.
It's derpy and only does whole numbers, so you could treat it as a percentage modification or selector, i.e. option 1, 2, or 3.
*/

/*
 
Intensity
Range0-200, 80
$ 
Morph
Range25-100, 30
$ 
Brightness
Range0-200, 100
$ 
Edge
Range0-200, 70
$ 
Mix
Range0-70, 50
*/
// 

#define Intensity 80
#define Morph 30
#define Brightness 100
#define Edge 70
#define Mix 50
//                      

//how to get screen width not buffer width
texture texColorBuffer : COLOR; // or SV_Target

texture texImage < source = "noise.png"; >
{
	Width = 256;
	Height = 256;
};

sampler samplerColor
{
	Texture = texColorBuffer;
};

sampler samplerImage
{
	Texture = texImage;
};

void MainVS(in uint id : SV_VertexID, out float4 position : SV_Position, out float2 texcoord : TEXCOORD0)
{
	texcoord = float2((id == 2) ? 2.0 : 0.0, (id == 1) ? 2.0 : 0.0);
	position = float4(texcoord * float2(2.0, -2.0) + float2(-1.0, 1.0), 0.0, 1.0);
}

float4 PS(in float4 pos : SV_Position, in float2 texcoord : TEXCOORD0) : SV_Target
{
	float3 c11 = tex2D(samplerColor, texcoord).xyz;
	float3 paper = tex2D(samplerImage, texcoord).xyz;
	//float3 paper = float3(0.97,0.86,0.72); //Manual paper color.

	float dx =BUFFER_RCP_WIDTH;    //BUFFER_RCP_WIDTH;   
	float dy = 0.00095; //BUFFER_RCP_HEIGHT; 

	float3 c00 = tex2D(samplerColor, texcoord + float2(-dx, -dy)).xyz;
	float3 c10 = tex2D(samplerColor, texcoord  + float2( 0, -dy)).xyz;
	float3 c02 = tex2D(samplerColor, texcoord  + float2( dx, -dy)).xyz;
	float3 c01 = tex2D(samplerColor, texcoord + float2(-dx, 0)).xyz;
	float3 c21 = tex2D(samplerColor, texcoord + float2( dx, 0)).xyz;
	float3 c20 = tex2D(samplerColor, texcoord + float2(-dx, dy)).xyz;
	float3 c12 = tex2D(samplerColor, texcoord + float2( 0, dy)).xyz;
	float3 c22 = tex2D(samplerColor, texcoord + float2( dx, dy)).xyz;
	float3 dt = float3(1.0,1.0,1.0); 

	float d1=dot(abs(c00-c22),dt);
	float d2=dot(abs(c20-c02),dt);
	float hl=dot(abs(c01-c21),dt);
	float vl=dot(abs(c10-c12),dt);
	float d = (d1+d2+hl+vl)/(dot(c11+c10+c02+c22,dt)+0.2);
	d = max(Intensity/100.0*pow(abs(d),Morph/100.0) + d,0); //Intensity and morph

	c11 = max((Brightness/100.0-(Edge/100.0*d))*c11,0); //brightness, edge darkness/thickness
	d = min(d,1.1);
    d = max(d-0.1,0.0);
	d = pow(d,(Mix/100.0)); //Mix, set to 0 for no background color.
	return float4(lerp(paper, c11, d),1.0);
}

technique Example < enabled = true; >
{
	pass
	{
	    VertexShader = MainVS;
		PixelShader = PS;
	}

}